<% Option Explicit %>
<% Response.Buffer = True %>
<%

'Dimension variables
Dim adoCon 			'Database Connection Variable
Dim rsWeeklyPoll 		'Database Recordset Variable
Dim strCon			'Holds the Database driver and the path and name of the database
Dim strAccessDB 		'Holds the Access Database Name
Dim strSQL 			'Database query sring
Dim strPollVote			'Holds the poll vote choice from the user
Dim strPollQuestion 		'Holds the poll question
Dim intPollIDNum		'Holds the poll ID Number
Dim intToatalPollVotes		'Holds the total number of votes cast
Dim dblPollVotePercentage	'Holds the percentage of the poll votes choice
Dim intSelectionLoopCounter	'Loop counter to display the poll selections
Dim intReadInVotesLoopCounter	'Loop counter to read in the number of votes cast
Dim blnSaveVote			'Boolean to set to false if the user has already voted


'Initialise variables
intPollIDNum = 0
intToatalPollVotes = 0
blnSaveVote = True

'If this is not a previous poll to be displayed then read in the details from the form and save the choice
If Request.QueryString("PollID") = "" Then

	'Read in the Poll ID Number
	intPollIDNum = CInt(Request.Form("id"))
	
	'Read in the Poll Vote user choice
	strPollVote = Request.Form("PollVote")
	
	
	'If a vote has been cast then record the vote
	If NOT strPollVote = "" Then
	
		'Call the Save Poll Votes Function (This must be called before any HTML is written as it sets a Cookie)
		blnSaveVote =  SavePollVotes(strPollVote, intPollIDNum)
	
	End If

'Else this is a previous poll to display so show get the poll id number to display
Else

	'Read in the Poll ID Number of the previous poll to display
	intPollIDNum = CInt(Request.QueryString("PollID"))

End If
%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Weekly Poll Results</title>

<!-- The Surf-Net Weekly Poll is written and produced by Bruce Corkhill 2001
     	If you want your own Weekly Poll then goto http://www.surf-net.co.uk -->
     	
</head>
<body bgcolor="#330099" text="#FFFFFF" link="#66CCFF" vlink="#66CCFF" alink="#FF0000">
<h2 align="center">Weekly Poll</h2>
<table width="90%" border="0" cellspacing="0" cellpadding="1" align="center">
  <tr> 
    <td align="center"> 
      <%
      
      
'Read the Poll results from the database
'Initialise the strAccessDB variable with the name of the Access Database
strAccessDB = "weekly_poll"

'Create a connection odject
Set adoCon = Server.CreateObject("ADODB.Connection")
Set rsWeeklyPoll = Server.CreateObject("ADODB.Recordset")
			 
'Open connection to the database driver
strCon="DRIVER={Microsoft Access Driver (*.mdb)};"
		
'Open Connection to database
strCon = strCon & "DBQ=" & Server.MapPath(strAccessDB)


'Initalise the strSQL variable with an SQL statement to query the database
strSQL = "SELECT * FROM tblPolls "
If NOT intPollIDNum = 0 Then
	strSQL = strSQL & "WHERE tblPolls.id_no = " & intPollIDNum
End If
strSQL = strSQL & " ORDER By id_no DESC;"

'Query the database
rsWeeklyPoll.Open strSQL, strCon


'Check there is a weekly poll to display
If rsWeeklyPoll.EOF Then

	'If there is no weekly poll to display then display the appropriate message
	Response.Write vbCrLf & "There is no Weekly Poll to display"

'Else there is a weekly poll to write the HTML to display it
Else 	
	
	'Read in the polling question from the database
	strPollQuestion = rsWeeklyPoll("Question")
	
	'Read in the polling question ID No from the database
	intPollIDNum = CInt(rsWeeklyPoll("id_no"))
		
	'Loop round to read in the number of votes cast
	For intReadInVotesLoopCounter = 1 To 7
		
		'Read in the total number of votes cast
		intToatalPollVotes = intToatalPollVotes + CInt(rsWeeklyPoll("Votes_" & intReadInVotesLoopCounter & ""))
	Next
	
	  	
	  	
	'Display the HTML for the weekly poll	
	
	'If the user has already voted once before in this poll vote then display the approriate message
	If blnSaveVote = False Then
		'If the user has already voted then display an appriorate message
		Response.Write vbCrLf & "<span class=""arial"">Sorry, you have already voted in this Weeks Poll</span>"
		Response.Write vbCrLf & "<br><br>"
	End If
	 
        Response.Write vbCrLf & "    <table width=""100%"" border=""0"" cellspacing=""0"" cellpadding=""1"">"
        Response.Write vbCrLf & "      <tr>"
        
        'Display the poll question            
	Response.Write vbCrLf & "            <td align=""center"" height=""31"">" & strPollQuestion & "</td>"
	
	Response.Write vbCrLf & "      </tr>"
	Response.Write vbCrLf & "     </table>"	
	
	Response.Write vbCrLf & "       <table width=""200"" border=""0"" cellspacing=""0"" cellpadding=""1"" align=""center"">"
	
	'Loop to display each of the selection choices for the poll
	For intSelectionLoopCounter = 1 To 7
	
		'If there is a Selection choice then display the HTML to show it
		If NOT rsWeeklyPoll("Selection_" & intSelectionLoopCounter) = "" Then
			
			'If there are no votes yet then format the percent by 0 otherwise the sums corse problems
			If intToatalPollVotes = 0 Then 
				dblPollVotePercentage = FormatPercent(0, 0)
				
			Else
				'Read in the the percentage of votes cast for the vote choice
				dblPollVotePercentage = FormatPercent((rsWeeklyPoll("Votes_" & intSelectionLoopCounter) / intToatalPollVotes), 0)
			End If
			
			'Display the selection choice results
			Response.Write vbCrLf & "  	     <tr>"
			Response.Write vbCrLf & "  	       <td colspan=""3"">" & rsWeeklyPoll("Selection_" & intSelectionLoopCounter) & "</td>"
			Response.Write vbCrLf & "  	     </tr>"
			Response.Write vbCrLf & "  	     <tr>"
			Response.Write vbCrLf & "  	     <td width=""142""><img src=""bar_graph_image.gif"" width=""" & dblPollVotePercentage & """ height=""15""></td>"
			Response.Write vbCrLf & "  	     <td width=""7"" align=""right"">" & dblPollVotePercentage & "</td>"
			Response.Write vbCrLf & "  	     </tr>"
			
		End If
	Next
	
	Response.Write vbCrLf & "	     </table>"
	
	'Display the total votes cast    
	Response.Write vbCrLf & "		Total Votes: " & intToatalPollVotes
	
End If


'Reset Server Objects
Set adoCon = Nothing
rsWeeklyPoll.Close
Set rsWeeklyPoll = Nothing      
%>
    </td>
  </tr>
</table>

  
<table width="98%" border="0" cellspacing="0" cellpadding="0" align="center">
  <tr>
    <td align="center" valign="bottom" height="29"><a href="previous_weekly_polls.asp?PagePosition=<% = Request.QueryString("PagePosition") %>" target="poll">Previous 
      Weekly Polls</a> </td>
  </tr>
  <tr>
    <td align="center" height="31"><a href="JavaScript:window.close()">Close Window</a></td>
  </tr>
</table>
<div align="center"><a href="http://www.surf-net.co.uk" target="_blank"><img src="surf-net_logo.gif" width="88" height="31" border="0" alt="Surf-net"></a> 
</div>
</body>
</html>
<%

'Sub function to save the users Poll Vote Choice
Private Function SavePollVotes(ByRef strPollVoteChoice, ByRef intPollIDNum)

	'Dimension variables
	Dim adoCon 			'Database Connection Variable
	Dim rsSavePollVotes 		'Database Recordset Variable
	Dim strCon			'Holds the Database driver and the path and name of the database
	Dim strAccessDB 		'Holds the Access Database Name
	Dim strSQL 			'Database query sring
	Dim intVoteChoiceCount		'Holds the number of votes for the choice selected
	Dim intVotedIDNo		'Holds the number of any previous polls the user has voted in
	
	
	'Intialise variables
	SavePollVotes = True
	
	
	'Check the user has not already voted by reading in a cookie from there system
	'Read in the Poll ID number of the last poll the user has voted in
	intVotedIDNo = CInt(Request.Cookies("Poll")("PollID"))
	
	'Check to see if the user has voted in this poll
	If intVotedIDNo = intPollIDNum Then
	
		'If the user has already voted then return flase
		SavePollVotes = False
	
	'Else if the user has not already voted so increment the vote choice total and set a cookie on the users system
	Else
		
		'Read in the vote choice numbers from the database
		'Initialise the strAccessDB variable with the name of the Access Database
		strAccessDB = "weekly_poll"
		
		'Create a connection odject
		Set adoCon = Server.CreateObject("ADODB.Connection")
		Set rsSavePollVotes = Server.CreateObject("ADODB.Recordset")
					 
		'Open connection to the database driver
		strCon="DRIVER={Microsoft Access Driver (*.mdb)};"
				
		'Open Connection to database
		strCon = strCon & "DBQ=" & Server.MapPath(strAccessDB)
		
		
		'First we need to read in the present vote number so we can add 1 to it
		'Initalise the strSQL variable with an SQL statement to query the database
		strSQL = "SELECT * FROM tblPolls "
		strSQL = strSQL & " WHERE id_no =" & CInt(intPollIDNum)
		
		'Set the cursor type property of the recordset to Dynamic so we can navigate through the record set
		rsSavePollVotes.CursorType = 2
	
		'Set the Lock Type for the records so that the recordset is only locked when it is updated
		rsSavePollVotes.LockType = 3
		
		'Query the database
		rsSavePollVotes.Open strSQL, strCon
						
		
		'Read in the value of the vote choice selected form the database	
		intVoteChoiceCount = CInt(rsSavePollVotes(strPollVoteChoice))
		      	
		'Increment the vote choice by 1
		intVoteChoiceCount = intVoteChoiceCount + 1
		 		 
		    
		'Update the database with the new poll results	
		rsSavePollVotes.Fields(strPollVote) = CInt(intVoteChoiceCount)			
		rsSavePollVotes.Update
		
		'Re-run the query to read in the updated recordset from the database for the poll results
		rsSavePollVotes.Requery
						
	
		'Reset Server Objects 
		Set adoCon = Nothing
		rsSavePollVotes.Close
		Set rsSavePollVotes = Nothing 
	 	
		
		'Write a cookie with the Poll ID number so the user cannot keep voting on this poll		
		'Write the cookie with the name Poll containing the value PollID
		Response.Cookies("Poll")("PollID") = intPollIDNum
		
		'Set the expiry date for 14 days
		Response.Cookies("Poll").Expires = Now() + 14

	End If
	
End Function

%>